------------------------------------------------------------------------------
-- Split View Left, Revision: 2.0 
--
-- tool script
--
-- This script will view the current tool in the left display view, and the 
-- primary input in the 'B' buffer. It will then split wipes the image from 
-- right to left across the screen.
--
-- It's useful for comparing the source against the result of a tool. Its also a good 
-- example of manipulating the display views using a script.
--
--
-- written by : Isaac Guenard (izyk@eyeonline.com)
-- written    : August 28th, 2003
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------------------------

if not tool then
	tool = composition:GetAttrs().FLOWH_ActiveTool
	if not tool then
		print("This is a tool script, you must select a tool in the flow to run this script")
		return
	end
end

-- intervals defines how finely the splitwipe animates
intervals = 50
--seconds defines how long it takes the splitwipe to progress from right to left
seconds = 3

inps = {}

a_view = composition:GetPreviewList()["Right"]
b_view = composition:GetPreviewList()["Right.B"]

-- get tool connected to this tools primary input.
inp_list = tool:GetInputList()
v = ""
for i, w in pairs(inp_list) do 
  a = w:GetAttrs()
	
  if ( a.INPS_DataType == "Image") and (a.INPS_ID == "Input") then --hold this for now
	v = w
	break
  end
end

if v ~= "" then

	--if the input is connected.....
	if v:GetConnectedOutput() then
	  t = v:GetConnectedOutput():GetTool()
	else 
	  t = tool
	end
	
	-- view both tools
	a_view:ViewOn(t)
	b_view:ViewOn(tool)
	
	-- scale the view to fit
	a_view.View:SetScale(0)
	
	-- set the split position and enable it
	a_view.View:SetSplit(1.0, .5, 90)
	
	a_view.View:SetBuffer(2)
	
	-- comment everything below with --[[ and ]]-- 
	-- if you dont want the wipe
	wait(0.5)
	 
	for i = 1, intervals do
		x = (1/intervals) * i
		a_view.View:SetSplit(1.0 - x, .5, 90)
		wait(seconds/intervals)
	end
	
	wait(2)
	a_view.View:SetSplit(.5, .5, 90)
else
	print("This tool has no input to compare....")
end
